/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.clipboard;

import com.moulberry.axiom.Restrictions;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.clipboard.Clipboard;
import com.moulberry.axiom.clipboard.Placement;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.clipboard.SelectionHistoryElement;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.world_modification.Dispatcher;
import java.text.NumberFormat;
import java.util.function.UnaryOperator;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

public class Selection {
    private static SelectionBuffer buffer = SelectionBuffer.EMPTY;
    private static boolean renderSelection = true;

    public static void render(class_4184 camera, long time, class_4587 matrices, Matrix4f projection, int effects) {
        if (!renderSelection) {
            return;
        }
        buffer.render(camera, time, matrices, projection, effects);
    }

    public static SelectionBuffer getSelectionBuffer() {
        return buffer;
    }

    public static boolean shouldRenderSelection() {
        return renderSelection;
    }

    public static void setShouldRenderSelection(boolean renderSelection) {
        Selection.renderSelection = renderSelection;
    }

    public static int selectedBlockCount() {
        return buffer.size();
    }

    public static boolean contains(int x, int y, int z) {
        if (!EditorUI.isActive()) {
            return true;
        }
        return buffer.contains(x, y, z);
    }

    public static void setBuffer(SelectionBuffer selectionBuffer) {
        selectionBuffer = selectionBuffer.optimize();
        if (buffer == (selectionBuffer = Restrictions.constrainSelection(selectionBuffer))) {
            return;
        }
        buffer.close();
        buffer = selectionBuffer;
    }

    public static void set(ChunkedBooleanRegion booleanRegion) {
        if (booleanRegion.count() <= 0) {
            Selection.clearSelection();
            return;
        }
        class_2338 oldCenter = buffer.center();
        int oldCount = buffer.size();
        SelectionHistoryElement oldElement = buffer.createHistoryElement();
        Selection.setBuffer(new SelectionBuffer.Set(booleanRegion));
        buffer.pushActiveSelectionHistory(oldCenter, oldCount, oldElement);
    }

    public static void modify(UnaryOperator<ChunkedBooleanRegion> consumer) {
        Selection.setBuffer(buffer.modify(consumer, true));
    }

    public static void modifyWithHistory(UnaryOperator<ChunkedBooleanRegion> consumer, boolean history) {
        Selection.setBuffer(buffer.modify(consumer, history));
    }

    public static void move(int x, int y, int z, boolean history) {
        Selection.setBuffer(buffer.move(x, y, z, history));
    }

    public static void addAABB(class_2338 min2, class_2338 max2) {
        Selection.setBuffer(buffer.addAABB(min2, max2, true));
    }

    public static void subtractAABB(class_2338 min2, class_2338 max2) {
        Selection.setBuffer(buffer.subtractAABB(min2, max2, true));
    }

    public static void intersectAABB(class_2338 min2, class_2338 max2) {
        Selection.setBuffer(buffer.intersectAABB(min2, max2, true));
    }

    public static void addAABBWithHistory(class_2338 min2, class_2338 max2, boolean history) {
        Selection.setBuffer(buffer.addAABB(min2, max2, history));
    }

    public static void addSet(PositionSet positionSet) {
        Selection.setBuffer(buffer.addSet(positionSet, true));
    }

    public static void subtractSet(PositionSet positionSet) {
        Selection.setBuffer(buffer.subtractSet(positionSet, true));
    }

    public static void intersectSet(PositionSet positionSet) {
        Selection.setBuffer(buffer.intersectSet(positionSet, true));
    }

    public static void clearSelection() {
        Dispatcher.clearActiveSelectionHistory();
        Selection.setBuffer(SelectionBuffer.EMPTY);
    }

    public static void clearSelectionNoHistory() {
        Selection.setBuffer(SelectionBuffer.EMPTY);
    }

    public static UserAction.ActionResult callAction(UserAction action, Object object) {
        if (!EditorUI.isActive()) {
            return UserAction.ActionResult.NOT_HANDLED;
        }
        switch (action) {
            case COPY: {
                Selection.callCopy();
                return UserAction.ActionResult.USED_STOP;
            }
            case DELETE: {
                Selection.callDelete();
                return UserAction.ActionResult.USED_STOP;
            }
            case CUT: {
                Selection.callCut();
                return UserAction.ActionResult.USED_STOP;
            }
            case DUPLICATE: {
                Selection.callDuplicate();
                return UserAction.ActionResult.USED_STOP;
            }
            case ENTER: {
                Selection.clearSelection();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    private static void callDelete() {
        buffer.callDelete();
        Selection.clearSelection();
    }

    private static void callCut() {
        class_2338 center = buffer.center();
        if (center != null) {
            if (Placement.INSTANCE.isPlacing()) {
                Placement.INSTANCE.stopPlacement();
            }
            buffer.callCopy(true, false).thenAccept(copyResult -> {
                if (copyResult != null && !copyResult.chunkedBlockRegion().isEmpty()) {
                    ChunkedBlockRegion blockBuffer = copyResult.chunkedBlockRegion();
                    class_2338 newCenter = center.method_10069((blockBuffer.max().method_10263() + blockBuffer.min().method_10263()) / 2, (blockBuffer.max().method_10264() + blockBuffer.min().method_10264()) / 2, (blockBuffer.max().method_10260() + blockBuffer.min().method_10260()) / 2);
                    String formattedCount = NumberFormat.getInstance().format(blockBuffer.count());
                    String description = AxiomI18n.get("axiom.history_description.placed", formattedCount);
                    Placement.INSTANCE.startPlacement(newCenter, blockBuffer, copyResult.blockEntities(), description);
                    if (Configuration.keybind.cutAlsoCopiesToClipboard) {
                        float preferredYaw = 135.0f;
                        class_1297 entity = class_310.method_1551().field_1719;
                        if (entity != null) {
                            double dx = entity.method_23317() - (double)center.method_10263();
                            double dz = entity.method_23321() - (double)center.method_10260();
                            preferredYaw = (float)(-Math.toDegrees(Math.atan2(dx, dz)));
                        }
                        Clipboard.INSTANCE.setClipboard(copyResult.chunkedBlockRegion(), copyResult.blockEntities(), "", preferredYaw);
                    }
                }
            });
        }
        Selection.clearSelection();
    }

    private static void callCopy() {
        class_2338 center = buffer.center();
        if (center != null) {
            if (Placement.INSTANCE.isPlacing()) {
                Placement.INSTANCE.stopPlacement();
            }
            buffer.callCopy(false, false).thenAccept(copyResult -> {
                if (copyResult != null && !copyResult.chunkedBlockRegion().isEmpty()) {
                    float preferredYaw = 135.0f;
                    class_1297 entity = class_310.method_1551().field_1719;
                    if (entity != null) {
                        double dx = entity.method_23317() - (double)center.method_10263();
                        double dz = entity.method_23321() - (double)center.method_10260();
                        preferredYaw = (float)(-Math.toDegrees(Math.atan2(dx, dz)));
                    }
                    Clipboard.INSTANCE.setClipboard(copyResult.chunkedBlockRegion(), copyResult.blockEntities(), "", preferredYaw);
                }
            });
        }
        Selection.clearSelection();
    }

    private static void callDuplicate() {
        class_2338 center = buffer.center();
        if (center != null) {
            if (Placement.INSTANCE.isPlacing()) {
                Placement.INSTANCE.stopPlacement();
            }
            buffer.callCopy(false, false).thenAccept(copyResult -> {
                if (copyResult != null && !copyResult.chunkedBlockRegion().isEmpty()) {
                    ChunkedBlockRegion blockBuffer = copyResult.chunkedBlockRegion();
                    class_2338 newCenter = center.method_10069((blockBuffer.max().method_10263() + blockBuffer.min().method_10263()) / 2, (blockBuffer.max().method_10264() + blockBuffer.min().method_10264()) / 2, (blockBuffer.max().method_10260() + blockBuffer.min().method_10260()) / 2);
                    String formattedCount = NumberFormat.getInstance().format(blockBuffer.count());
                    String description = AxiomI18n.get("axiom.history_description.placed", formattedCount);
                    Placement.INSTANCE.startPlacement(newCenter, blockBuffer, copyResult.blockEntities(), description);
                }
            });
        }
        Selection.clearSelection();
    }
}

